/******************************************************************************
                                             COPYRIGHT (c) FREESCALE 2005  
                                                                           
File Name          :    $RCSfile: S12VREGL_3V3V1.h,v $                     
                                                                          
Current Revision :      $Revision: 1.0 $                                  
                                                                           
PURPOSE: header file for S12X VREGL register block                         
                                                                           
DESCRIPTION:  Defines the VREGL register block as a datastructure of       
              type tVREG.                                                 
                                                                           
UPDATE HISTORY                                                            
REV  AUTHOR      DATE        DESCRIPTION OF CHANGE                        
---  ------      --------    ---------------------                        
1.0  r54430      19/04/04    - Initial Revision                           


      *****************************************************************
      *File created by: Freescale East Kilbride MCD Applications Group*
      *****************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef S12VREGL_3V3V1_H       /*prevent duplicated includes */
#define S12VREGL_3V3V1_H

#include "S12_COMMON.h"

typedef union uVREGHTCL /* ----- factory use only */
{
  tU08   byte;
  struct
  {
    tU08 htif  :1;
    tU08 htie  :1;
    tU08 htds  :1;
    tU08       :1;
    tU08 vae   :1;
    tU08 vsel  :1;
    tU08 ttst  :1;
    tU08       :1;
  }bit;
} tVREGHTCL;

/*bit masks for VREGHTCL*/
#define HTIF   0x01  
#define HTIE   0x02
#define HTDS   0x04
#define VAE    0x10   
#define VSEL   0x20
#define TTST   0x40

typedef union uVREGCTRL
{
  tU08   byte;
  struct
  {
    tU08 lvif  :1;        /* low voltage interrupt flag */
    tU08 lvie  :1;        /* low voltage interrupt enable */
    tU08 lvds  :1;        /* low voltage detect status */
	 tU08 		:5;        /* not used */           
  }bit;
} tVREGCTRL;

/*bit masks for VREGCTRL*/
#define LVIF   0x01  
#define LVIE   0x02
#define LVDS   0x04

typedef union uVREGAPICL
{
  tU08   byte;
  struct
  {
    tU08 apif   :1;		  /* API interrupt flag */
    tU08 apie   :1;		  /* API interrupt enable */
    tU08 apife  :1;		  /* API module enable */
    tU08        :4;
    tU08 apiclk :1;
  } bit;
} tVREGAPICL;

/*bit masks for VREGAPICL*/
#define APIF   0x01  
#define APIE   0x02
#define APIFE  0x04
#define APICLK 0x80


typedef union uVREGAPITR
{
  tU08   byte;
  struct
  {
    tU08 rcexa  :1; /* ----- factory use only */
    tU08        :1;		  /* not used */
    tU08 apitr  :6;		  /* API trim bits */
  } bit;
} tVREGAPITR;

/*bit masks for VREGAPITR*/
#define RCEXA   0x01 /* ---- factory use only */
#define APTR0   0x04  
#define APTR1   0x08
#define APTR2   0x10
#define APTR3   0x20
#define APTR4   0x40
#define APTR5   0x80

typedef struct {           /* vreg datastructure   */
  volatile tVREGHTCL   vreghtcl;   /* factory use only */  
  volatile tVREGCTRL   vregctrl;   /* Vreg Control Register */ 
  volatile tVREGAPICL  vregapicl;  /* API Control Register */  
  volatile tVREGAPITR  vregapitr;  /* API trim Register */  
  volatile tU16        vregapir;   /* API rate Register - writeable only when API disabled */
  volatile tREG08      rsv6;     
  volatile tREG08      rsv7;     
} tVREG;

#endif /*S12VREGL_3V3V1_H */